function [Y,ybar,yproj,A] = cos_transform(y,q);
% Cosine transform and related statistics
% Eigenvalues from demeaned random walk covariance matrix
% y is n_t x n_s
 
 n_t = size(y,1);
 n_s = size(y,2);
 
 % ---- Brute Force Calculation of Eigenvectors ----
%  % Compute RW Covariance Matrix
%  cov_rw = rw_cov(n_t);
%  % Compute Regressor:  Here a constant
%  X = ones(n_t,1);     % Constant Regressors
%  pX = X*inv(X'*X)*X';
%  S_fs = eye(n_t) - pX;
%  cov_fs = S_fs*cov_rw*S_fs';
%  [evec_mat,eval]=eig(cov_fs,'vector');
%  A = evec_mat(:,1:q);
%  
 % --- Use Analytic Formula for eigenvalues
 % --- Use Analytic Formula for eigenvalues
 fvec = pi*(1:1:q);
 tvec = (0.5:1:n_t)'/n_t;
 A = (sqrt(2/n_t))*cos(tvec*fvec);
 
 ybar = mean(y)';
 Y = inv(A'*A)*A'*y;
 yproj = A*Y + ybar';
 
end

